//
//  AppDelegate.m
//  BT004 Test
//
//  Created by James Henderson on 02/05/2014.
//  Copyright (c) 2014 Devantech Ltd. All rights reserved.
//

#import "AppDelegate.h"


@implementation AppDelegate

@synthesize idString;
@synthesize softString;
@synthesize hardString;
@synthesize deviceName;

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{

    // Init stuff
    self.deviceName = [NSMutableString stringWithFormat:@""];
    alert = [NSAlert alertWithMessageText:@"" defaultButton:nil alternateButton:nil otherButton:nil informativeTextWithFormat:@""];
    isRelayStates = TRUE;
    modId = 0;
    softVer = 0;
    hardVer = 0;
    
    // Show the bluetooth device selector on start up
    [progress startAnimation:self];
    [self showDeviceSelector];
    
    [[relayButton1 cell] setBackgroundColor:[NSColor whiteColor]];  // Set buttons default white colour
    [[relayButton2 cell] setBackgroundColor:[NSColor whiteColor]];
    [[relayButton3 cell] setBackgroundColor:[NSColor whiteColor]];
    [[relayButton4 cell] setBackgroundColor:[NSColor whiteColor]];
    
    relayStatesTimer = [NSTimer scheduledTimerWithTimeInterval:0.5f target:self selector:@selector(relayState:) userInfo:nil repeats:YES];
}


- (void) showDeviceSelector
{
    IOBluetoothDeviceSelectorController *ctrl = [IOBluetoothDeviceSelectorController deviceSelector];
    
    int res = [ctrl runModal];                              // Stop at this point untill user makes a selection or cancels
    
    if (res != kIOBluetoothUISuccess) {
        NSLog(@"Either invalid device selected or user cancelled");
        return;
    }
    
    NSArray *results = [ctrl getResults];                   // Get the results of the users selection
    
    if ([results count] == 0) {
        NSLog(@"Error with results encountered");
        return;
    }
    
    IOBluetoothDevice *device = [results objectAtIndex:0];  // Grab the bluetooth device
    btDevice = device;
    self.deviceName = [NSString stringWithFormat:@"%@",[btDevice name]];
    
    [connectingPannel makeKeyAndOrderFront:self];           // Show the connecting view while we try to connect
    
    IOReturn ret = [btDevice performSDPQuery:self];         // Start an SDP Query, if it comes back ok then start a connection
    if (ret != kIOReturnSuccess) {
        NSLog(@"SDP failed");
        return;
    }
}

//called during SDP step.
- (void)sdpQueryComplete:(IOBluetoothDevice *)device status:(IOReturn)status
{
    if (status != kIOReturnSuccess) {
        NSLog(@"SDP status %d", status);
        alert = [NSAlert alertWithMessageText:@"Failed to connect" defaultButton:nil alternateButton:nil otherButton:nil informativeTextWithFormat:@"Connection has failed, try again"];
        [connectingPannel close];
        [alert runModal];
        [self showDeviceSelector];
        return;
    }
    NSLog(@"SDP Done");
    [self startConnection];
}

// Called once an SDP has finished
- (void) startConnection
{
    BluetoothRFCOMMChannelID rfCommChan;
    if([self findRfCommChannel:&rfCommChan] != kIOReturnSuccess) //check If the device have RFCOMM channel.
        return;
    
    NSLog(@"Found rfcomm %d",rfCommChan);
    if (![self openConnection:&rfCommChan])
    {
        alert = [NSAlert alertWithMessageText:@"Connect failed" defaultButton:nil alternateButton:nil otherButton:nil informativeTextWithFormat:@"Could not open connection, try again."];
        [connectingPannel close];
        [alert runModal];
        [self showDeviceSelector];
    }
    
}

//get the RfComm channel.
-(IOReturn) findRfCommChannel:(BluetoothRFCOMMChannelID *) rfChan
{
    if(btDevice == nil)
        return kIOReturnNotFound;
    IOReturn ret;
    NSArray* services = [btDevice services];
    BluetoothRFCOMMChannelID newChan;
    for (IOBluetoothSDPServiceRecord* service in services) {
        NSLog(@"Service: %@", [service getServiceName]);
        ret = [service getRFCOMMChannelID:&newChan];
        if (ret == kIOReturnSuccess) {
            *rfChan = newChan;
            NSLog(@"ChannelID %d %d", newChan, *rfChan);
            return kIOReturnSuccess;
        }
    }
    
    return kIOReturnNotFound;
}

//Open the connection.
-(BOOL) openConnection:(BluetoothRFCOMMChannelID *) chanId
{
    IOBluetoothRFCOMMChannel *channel;
    if ([btDevice openRFCOMMChannelAsync:&channel withChannelID:*chanId delegate:self] != kIOReturnSuccess) { // after connection it is established.. the delegates methoed are triggered.
        NSLog(@"Couldn't open channel");
        return NO;
    }
    [channel closeChannel];
    return YES;
}

//delegate RFComm channel
- (void)rfcommChannelOpenComplete:(IOBluetoothRFCOMMChannel*)rfcommChannel
                           status:(IOReturn)error
{
    if (error != kIOReturnSuccess) {
        NSLog(@"Failed to open channel, error %d", error);
        alert = [NSAlert alertWithMessageText:@"Failed to connect" defaultButton:nil alternateButton:nil otherButton:nil informativeTextWithFormat:@"Connection has failed, try again"];
        [connectingPannel close];
        [alert runModal];
        [self showDeviceSelector];
        return;
    }
    NSLog(@"channel complete");
    [connectingPannel close];
    [window makeKeyAndOrderFront:self];
    channel = rfcommChannel;
    char outString[] = {0x10};
    [channel writeAsync:outString length:1 refcon:NULL];   // Grab the module data
    
}

//connection closed.
- (void)rfcommChannelClosed:(IOBluetoothRFCOMMChannel*)rfcommChannel
{
    NSLog(@"Channel closed");
}

//writing data to rfcomm
- (void)rfcommChannelWriteComplete:(IOBluetoothRFCOMMChannel*)rfcommChannel refcon:(void*)refcon status:(IOReturn)error
{
}

//reading data from rfcomm
- (void)rfcommChannelData:(IOBluetoothRFCOMMChannel*)rfcommChannel data:(void *)dataPointer length:(size_t)dataLength
{
    int dataIndex = 0;
    NSString *newStr = [[NSString alloc] initWithBytes:dataPointer length:dataLength encoding:NSASCIIStringEncoding];
    for (dataIndex = 0; dataIndex < dataLength; dataIndex++) {
     
        switch (whatData) {
            case 0:                                                                         // BT004 module ID
                modId = [newStr characterAtIndex:dataIndex];
                self.idString = [NSString stringWithFormat:@"Module ID: %d", modId];
                whatData++;
                break;
            case 1:                                                                         // Software version of BT004
                softVer = [newStr characterAtIndex:dataIndex];
                self.softString = [NSString stringWithFormat:@"Firmware v:%d",softVer];
                whatData++;
                break;
            case 2:                                                                         // Hardware version of BT004
                hardVer = [newStr characterAtIndex:dataIndex];
                self.hardString = [NSString stringWithFormat:@"Hardware v:%d",hardVer];
                whatData++;
                char outString[] = {0x10};
                [channel writeAsync:outString length:1 refcon:NULL];
                isConnected = TRUE;
                isRelayStates = TRUE;
                break;
            case 3:
                NSLog(@"%i",[newStr characterAtIndex:dataIndex]);
                if (isRelayStates)
                {
                    isRelayStates = FALSE;
                    relayStates = [newStr characterAtIndex:dataIndex];                      // Set the button colours according to relay states
                    if (relayStates & 0x01) {
                        [[relayButton1 cell] setBackgroundColor:[NSColor redColor]];
                    } else {
                        [[relayButton1 cell] setBackgroundColor:[NSColor whiteColor]];
                    }
                    if (relayStates & 0x02) {
                        [[relayButton2 cell] setBackgroundColor:[NSColor redColor]];
                    } else {
                        [[relayButton2 cell] setBackgroundColor:[NSColor whiteColor]];
                    }
                    if (relayStates & 0x04) {
                        [[relayButton3 cell] setBackgroundColor:[NSColor redColor]];
                    } else {
                        [[relayButton3 cell] setBackgroundColor:[NSColor whiteColor]];
                    }
                    if (relayStates & 0x08) {
                        [[relayButton4 cell] setBackgroundColor:[NSColor redColor]];
                    } else {
                        [[relayButton4 cell] setBackgroundColor:[NSColor whiteColor]];
                    }
                }
                break;
            default:
                break;
        }
    }
}

- (void)relayState:(id)sender
{
    if (isConnected)
    {
        isRelayStates = TRUE;                                   // Flag to show that the relay states will received from the module
        char outString[] = {0x24};                              // get realy states
        [channel writeAsync:outString length:1 refcon:NULL];
    }
}

- (IBAction)cancelConnection:(id)sender
{
    btDevice = nil;
    [connectingPannel close];
    [self showDeviceSelector];
}

- (IBAction)relaytoggle1:(id)sender
{
    if (!(relayStates & 0x01)) {
        char outString[] = {0x20,1,0};                          // Relay 1 active, no pulse time
        [channel writeAsync:outString length:3 refcon:NULL];
    }
    else {
        char outString[] = {0x21,1,0};                          // Relay 1 inactive, no pulse time
        [channel writeAsync:outString length:3 refcon:NULL];
    }
}

- (IBAction)relaytoggle2:(id)sender
{
    if (!(relayStates & 0x02)) {
        char outString[] = {0x20,2,0};
        [channel writeAsync:outString length:3 refcon:NULL];
    }
    else {
        char outString[] = {0x21,2,0};
        [channel writeAsync:outString length:3 refcon:NULL];
    }
}

- (IBAction)relaytoggle3:(id)sender
{
    if (!(relayStates & 0x04)) {
        char outString[] = {0x20,3,0};
        [channel writeAsync:outString length:3 refcon:NULL];
    }
    else {
        char outString[] = {0x21,3,0};
        [channel writeAsync:outString length:3 refcon:NULL];
    }
}

- (IBAction)relaytoggle4:(id)sender
{
    if (!(relayStates & 0x08)) {
        char outString[] = {0x20,4,0};
        [channel writeAsync:outString length:3 refcon:NULL];
    }
    else {
        char outString[] = {0x21,4,0};
        [channel writeAsync:outString length:3 refcon:NULL];
    }
}

@end
